﻿//////////////////////////////////////////////
// ThreeChannelPack.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkAstraeus
#include "../../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------

namespace nkAstraeus
{
	enum class THREE_CHANNEL_PACK
	{
		RGB = 0,
		RBG,
		RGA,
		RAG,
		RBA,
		RAB,
		GRB,
		GBR,
		GRA,
		GAR,
		GBA,
		GAB,
		BRG,
		BGR,
		BRA,
		BAR,
		BGA,
		BAG,
		ARG,
		AGR,
		AGB,
		ABG,
		ARB,
		ABR
	} ;

	class DLL_ASTRAEUS_EXPORT ThreeChannelPackUtils final
	{
		public :

			// Translation
			static nkMemory::StringView enumToStringLower (THREE_CHANNEL_PACK value) ;
			static THREE_CHANNEL_PACK stringLowerToEnum (nkMemory::StringView value) ;
	} ;
}